/*
 *  arch/arm/include/asm/cache.h
 */
#ifndef __ASMARM_CACHE_H
#define __ASMARM_CACHE_H

#define L1_CACHE_SHIFT		CONFIG_ARM_L1_CACHE_SHIFT
#define L1_CACHE_BYTES		(1 << L1_CACHE_SHIFT)

#ifdef CONFIG_UNIPHIER_HAS_L2CA
#define L2_CACHE_SHIFT		(7)
#define L2_CACHE_BYTES		(1 << L2_CACHE_SHIFT)
#define cache_line_size()	L2_CACHE_BYTES
#endif /* CONFIG_UNIPHIER_HAS_L2CA */
/*
 * Memory returned by kmalloc() may be used for DMA, so we must make
 * sure that all such allocations are cache aligned. Otherwise,
 * unrelated code may cause parts of the buffer to be read into the
 * cache before the transfer is done, causing old data to be seen by
 * the CPU.
 */
#if defined(L2_CACHE_BYTES) && (L1_CACHE_BYTES < L2_CACHE_BYTES)
#define ARCH_KMALLOC_MINALIGN	L2_CACHE_BYTES
#else
#define ARCH_KMALLOC_MINALIGN	L1_CACHE_BYTES
#endif

/*
 * With EABI on ARMv5 and above we must have 64-bit aligned slab pointers.
 */
#if defined(CONFIG_AEABI) && (__LINUX_ARM_ARCH__ >= 5)
#define ARCH_SLAB_MINALIGN 8
#endif

#endif
